"use server";
import { URL } from "@/config/config";
import { redirect, useRouter } from "next/navigation";
import { cookies } from "next/headers";
import { revalidatePath } from "next/cache";

export const getAllUsers = async () => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/getallusers`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
  });
  const data = await req.json();
  return data.data;
};

export const getAllDrivers = async () => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/getalldrivers`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
  });
  const data = await req.json();
  return data.data;
};

export const getRidesByType = async (type: string) => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/getallrides?rideType=${type}`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
  });
  const data = await req.json();
  console.log(data);
  return data.data.ride;
};

export const getRideBaseRate = async () => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/getridebaserate`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
  });
  const data = await req.json();
  console.log(data);
  return data.data;
};

export const changeFare = async (rideOnlyBaseRate: number) => {
  console.log("rideOnlyBaseRate");
  console.log(rideOnlyBaseRate);
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/createbaserate`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
    body: JSON.stringify({
      rideOnlyBaseRate,
    }),
  });
  const data = await req.json();
  revalidatePath("/(Admin)/fares-management");
  return data;
};
export const changeCut = async (adminCut: number) => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/createbaserate`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
    body: JSON.stringify({
      adminCut,
    }),
  });
  const data = await req.json();
  revalidatePath("/(Admin)/fares-management");
  return data;
};

export const getAnalytics = async () => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/getanalytics`, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
  });
  const data = await req.json();
  console.log(data);
  return data.data;
};

export const updatedriverstatus = async (
  driver_id: string,
  isApproved: boolean
) => {
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const req = await fetch(`${URL}/admin/updatedriverstatus`, {
    method: "PATCH",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
    body: JSON.stringify({
      driver_id,
      isApproved,
    }),
  });
  const data = await req.json();
  revalidatePath("/(Admin)/drivers");
  return data;
};
