"use server";
import { URL } from "@/config/config";
import { redirect, useRouter } from "next/navigation";
import { cookies } from "next/headers";
export const loginAPI = async (email: string, password: string) => {
  const req = await fetch(`${URL}/adminLogin`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({
      email,
      password,
      deviceType: "postman",
      deviceToken: "another",
    }),
  });
  const data = await req.json();
  console.log(data);
  if (data.status) {
    if (data.data.token) {
      const oneDay = 86400000;
      cookies().set("token", data.data.token, {
        expires: Date.now() + oneDay,
        httpOnly: true,
      });
    }
  }
  return data;
};

export const logout = () => {
  const cookieStore = cookies();
  cookieStore.delete("token");
  redirect("/");
};

export const forgetPassword = async (email: string) => {
  const req = await fetch(`${URL}/adminForget`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({
      email,
    }),
  });
  const data = await req.json();
  console.log(data);
  if (data.status) {
    if (data.data.token) {
      const oneDay = 86400000;
      cookies().set("forgotToken", data.data.token, {
        expires: Date.now() + oneDay,
        httpOnly: true,
      });
    }
  }
  return data;
};

export const adminVerifyOtp = async (otp: string) => {
  const cookieStore = cookies();
  const token = cookieStore.get("forgotToken");
  if (!token) {
    redirect("/");
  }
  const req = await fetch(`${URL}/admin/adminVerifyOtp`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
    body: JSON.stringify({
      otp,
      deviceToken: "abc",
      deviceType: "postman",
    }),
  });

  const data = await req.json();
  console.log(data);
  if (data.status) {
    if (data.data.token) {
      cookieStore.delete("forgotToken");
      const oneDay = 86400000;
      cookies().set("changePassToken", data.data.token, {
        expires: Date.now() + oneDay,
        httpOnly: true,
      });
    }
  }

  return data;
};

export const adminChangePassword = async (password: string) => {
  const cookieStore = cookies();
  const token = cookieStore.get("changePassToken");
  if (!token) {
    redirect("/");
  }
  const req = await fetch(`${URL}/admin/adminResetPassword`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${token!.value}`,
    },
    body: JSON.stringify({
      password,
      deviceToken: "abc",
      deviceType: "postman",
    }),
  });

  const data = await req.json();
  console.log(data);
  if (data.status) {
    if (data.data.token) {
      cookieStore.delete("forgotToken");
      const oneDay = 86400000;
      cookies().set("token", data.data.token, {
        expires: Date.now() + oneDay,
        httpOnly: true,
      });
    }
  }

  return data;
};
