import { NextResponse } from "next/server";

// import { kv } from "@vercel/kv";
import { cookies } from "next/headers";
export function middleware(req) {
  const { pathname } = req.nextUrl;
  if (
    pathname.startsWith("/api") || //  exclude all API routes
    pathname.startsWith("/static") || // exclude static files
    pathname.includes(".") // exclude all files in the public folder
  ) {
    return NextResponse.next();
  }

  // let this go through
  const cookieStore = cookies();
  const token = cookieStore.get("token");
  const forgotToken = cookieStore.get("forgotToken");
  const changePassToken = cookieStore.get("changePassToken");

  if (pathname === "/" || pathname === "/forgot-password") {
    return NextResponse.next();
  }
  if (pathname === "/forgot-password-otp" && forgotToken) {
    return NextResponse.next();
  }
  if (pathname === "/change-password" && changePassToken) {
    return NextResponse.next();
  }
  if (!token) {
    req.nextUrl.pathname = "/";
    return NextResponse.redirect(req.nextUrl);
  }

  // otherwise the header is present
  return NextResponse.next();
}
