"use client";

import { zodResolver } from "@hookform/resolvers/zod";
import { useForm } from "react-hook-form";
import { z } from "zod";

import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormDescription,
  FormField,
  FormItem,
  FormLabel,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { toast } from "@/components/ui/use-toast";
import { URL } from "@/config/config";
import { loginAPI } from "@/services/admin-service";
import { useRouter } from "next/navigation";
import Link from "next/link";

const FormSchema = z.object({
  email: z.string().email({
    message: "Please enter a valid email address.",
  }),
  password: z.string().min(1, {
    message: "Please Enter Password",
  }),
});

export function LoginForm() {
  const router = useRouter();
  const form = useForm<z.infer<typeof FormSchema>>({
    resolver: zodResolver(FormSchema),
    defaultValues: {
      email: "cityadmin@yopmail.com",
      password: "12345678",
    },
  });

  async function onSubmit(data: z.infer<typeof FormSchema>) {
    console.log("res");
    console.log(data.email);
    const reqserver: { status: string; message: string } = await loginAPI(
      data.email,
      data.password
    );
    console.log(reqserver);
    if (reqserver.status) {
      router.push("/dashboard");
    }
    // const res = await reqserver.json();
    // console.log(reqserver);
    // title: "You submitted the following values:",
    toast({
      title: reqserver.message,
      //   description: (
      //     <pre className="mt-2 w-[340px] rounded-md bg-slate-950 p-4">
      //       <code className="text-white">{JSON.stringify(data, null, 2)}</code>
      //     </pre>
      //   ),
    });
  }

  return (
    <>
      <Form {...form}>
        <form
          onSubmit={form.handleSubmit(onSubmit)}
          className="w-2/3 space-y-6"
        >
          <h1 className="text-3xl font-bold">LOGIN</h1>
          <FormField
            control={form.control}
            name="email"
            render={({ field }) => (
              <FormItem>
                <FormLabel>Email</FormLabel>
                <FormControl>
                  <Input placeholder="Enter Your Email" {...field} />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />
          <FormField
            control={form.control}
            name="password"
            render={({ field }) => (
              <FormItem>
                <FormLabel>Password</FormLabel>
                <FormControl>
                  <Input
                    type="password"
                    placeholder="Enter Your Password"
                    {...field}
                  />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />
          <span className="text-blue-400 underline justify-end flex">
            <Link href="/forgot-password">Forgot Password</Link>
          </span>
          <div className="flex justify-center">
            <Button type="submit" variant="appdefault" className="w-1/4">
              Login
            </Button>
          </div>
        </form>
      </Form>
      {/* <Button onClick={onSubmit2} className="w-1/2">
        onSubmit2
      </Button> */}
    </>
  );
}
