"use client";
import Link from "next/link";
import React from "react";
import LogoSmall from "/public/logoOnly-light.png";
import Image from "next/image";
import { Button } from "./ui/button";
import { usePathname } from "next/navigation";
import { appName } from "@/config/config";
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";
type Props = {};

const Sidenav = (props: Props) => {
  const pathname = usePathname();
  console.log(pathname);
  return (
    // <main className=" bg-gradient-to-t from-[#3A74FA] to-[#1D3A7D]  h-[100vh] rounded-r-md">
    <main className=" bg-gray-100/40 border h-[100vh] rounded-r-md">
      <div className="text-white m-4 p-2  rounded-lg flex justify-center items-center uppercase font-bold shadow-md shadow-gray-600 bg-[#3A74FA]">
        {/* <div className="text-white border border-gray-400 m-4 p-4 rounded-lg  flex justify-center items-center uppercase font-bold shadow-2xl bg-gradient-to-tl from-[#3A74FA] via-[#262e79] to-[#1D3A7D]"> */}
        <Image src={LogoSmall} alt="" width={30} className="mr-2 " />
        {appName}
      </div>
      <div className="border-t">
        {["dashboard", "users", "riders"].map((val, index) => {
          return (
            <React.Fragment key={index}>
              <ul>
                <li className=" m-2">
                  <Link href={`/${val}`}>
                    <Button
                      variant="appdefaultinv"
                      className={`w-full justify-start capitalize ${
                        pathname === `/${val}` ? "text-white" : "bg-transparent"
                      }`}
                    >
                      {val}
                    </Button>
                  </Link>
                </li>
              </ul>
            </React.Fragment>
          );
        })}

        <ul>
          <Accordion type="single" collapsible>
            <AccordionItem className="border-none" value="item-1">
              <AccordionTrigger
                className={`w-full hover:bg-[#3A74FA] hover:text-white  m-2 pl-[17.5px] text-sm pr-2 pt-2 pb-2 rounded-md capitalize ${
                  pathname === "/bookings/cancelled" ||
                  pathname === "/bookings/completed"
                    ? " bg-[#FFB300]"
                    : ""
                }`}
              >
                Bookings
              </AccordionTrigger>
              <AccordionContent>
                {["cancelled", "completed"].map((val, index) => {
                  return (
                    <React.Fragment key={index}>
                      <ul>
                        <li className="ml-6 m-2">
                          <Link href={`/bookings/${val}`}>
                            <Button
                              // disabled={pathname === `/bookings/${val}`}
                              variant="appdefaultinv"
                              className={`w-full justify-start capitalize ${
                                pathname === `/bookings/${val}`
                                  ? "text-white"
                                  : "bg-transparent"
                              }`}
                            >
                              {val}
                            </Button>
                          </Link>
                        </li>
                      </ul>
                    </React.Fragment>
                  );
                })}
              </AccordionContent>
            </AccordionItem>
          </Accordion>
        </ul>

        {[
          { link: "fares-management", name: "fares management" },
          { link: "admin-amount", name: "admin amount" },
        ].map((val, index) => {
          return (
            <React.Fragment key={index}>
              <ul>
                <li className=" m-2">
                  <Link href={`/${val.link}`}>
                    <Button
                      variant="appdefaultinv"
                      className={`w-full justify-start capitalize ${
                        pathname === `/${val.link}`
                          ? "text-white"
                          : "bg-transparent"
                      }`}
                    >
                      {val.name}
                    </Button>
                  </Link>
                </li>
              </ul>
            </React.Fragment>
          );
        })}
      </div>
    </main>
  );
};

export default Sidenav;
