"use client";

// import logout from "@/services/logout";
import { useRouter } from "next/navigation";
import { Button } from "./ui/button";
import { useToast } from "./ui/use-toast";
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from "./ui/dialog";
import { LogOut, LogOutIcon, Power, TrashIcon } from "lucide-react";
import { useState } from "react";
import { appName } from "@/config/config";
import { logout } from "@/services/admin-service";

const Logout = () => {
  const { toast } = useToast();
  const [loading, setLoading] = useState("Logout");
  const onSub = (e: any) => {
    setLoading(
      "loading"
      // <span className="animate-spin-right">
      //   <TbLoaderQuarter />
      // </span>
    );
    e.preventDefault();
    toast({
      variant: "destructive",
      title: "Logged Out Successfully",
      //  description: "Logged Out",
    });
    logout();
  };
  return (
    <Dialog>
      <DialogTrigger asChild>
        <Button variant="ghost" className="rounded-full">
          {/* <Power color="red" size={20} /> */}
          Logout
        </Button>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>Log Out</DialogTitle>
          <DialogDescription>
            Are you sure you want to Logout from{" "}
            <span className="capitalize">{appName}</span>
          </DialogDescription>
        </DialogHeader>
        <DialogFooter>
          <Button onClick={(e) => onSub(e)} variant="destructive" type="submit">
            {loading}
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
};

export default Logout;
