"use client";
import { zodResolver } from "@hookform/resolvers/zod";
import { useForm } from "react-hook-form";
import { z } from "zod";

import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormDescription,
  FormField,
  FormItem,
  FormLabel,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { toast } from "@/components/ui/use-toast";
import { URL } from "@/config/config";
import {
  adminChangePassword,
  forgetPassword,
  loginAPI,
} from "@/services/admin-service";
import { useRouter } from "next/navigation";
import Link from "next/link";

const FormSchema = z.object({
  password: z.string().min(1, {
    message: "Please Enter Password",
  }),
  confirmPassword: z.string().min(1, {
    message: "Please Enter Password",
  }),
});

const ChangePasswordPage = () => {
  const router = useRouter();
  const form = useForm<z.infer<typeof FormSchema>>({
    resolver: zodResolver(FormSchema),
    defaultValues: {
      password: "",
      confirmPassword: "",
    },
  });

  async function onSubmit(data: z.infer<typeof FormSchema>) {
    // console.log("hiiiiiiiiiiiiiiiiii");
    if (data.password !== data.confirmPassword) {
      toast({
        title: "Password and Confirm Password do not match.",
      });
    } else {
      const reqserver: { status: string; message: string } =
        await adminChangePassword(data.password);
      toast({
        title: reqserver.message,
      });
      if (reqserver.status) {
        router.push("/");
      }
    }
    // console.log("res");
    // console.log(data.email);
    // const reqserver: { status: string; message: string } = await forgetPassword(
    //   data.email
    // );
    // console.log(reqserver);
    // toast({
    //   title: reqserver.message,
    // });
    // if (reqserver.status) {
    //   router.push("/forgot-password-otp");
    // }
  }

  return (
    <div className="flex items-center">
      <div className="mx-auto max-w-md space-y-6">
        <div className="space-y-2 text-center">
          <h1 className="text-3xl font-bold text-white">Change Password</h1>
          {/* <p className="text-white/80 hidden">
            Enter your email address and we'll send you a link to reset your
            password.
          </p> */}
          <p className="text-white/80 w-[50vh]">Enter Your New Password</p>
        </div>
        <div className="flex justify-center">
          <Form {...form}>
            <form
              onSubmit={form.handleSubmit(onSubmit)}
              className="w-2/3 space-y-6"
            >
              {" "}
              <FormField
                control={form.control}
                name="password"
                render={({ field }) => (
                  <FormItem>
                    <FormLabel className="text-white">Password</FormLabel>
                    <FormControl>
                      <Input placeholder="Enter Password" {...field} />
                    </FormControl>
                    <FormMessage />
                  </FormItem>
                )}
              />
              <FormField
                control={form.control}
                name="confirmPassword"
                render={({ field }) => (
                  <FormItem>
                    <FormLabel className="text-white">
                      confirmPassword
                    </FormLabel>
                    <FormControl>
                      <Input
                        placeholder="Enter Password here again"
                        {...field}
                      />
                    </FormControl>
                    <FormMessage />
                  </FormItem>
                )}
              />
              <div className="flex justify-center">
                <Button type="submit" variant="appdefault" className="w-full">
                  Reset Password
                </Button>
              </div>
            </form>{" "}
          </Form>
        </div>
      </div>
    </div>
  );
};

export default ChangePasswordPage;
