"use client";
import {
  Tooltip,
  TooltipContent,
  TooltipProvider,
  TooltipTrigger,
} from "@/components/ui/tooltip";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import { Dialog, DialogContent, DialogTrigger } from "@/components/ui/dialog";
import { Label } from "@/components/ui/label";
import { Switch } from "@/components/ui/switch";
import { toast } from "@/components/ui/use-toast";
import { URL } from "@/config/config";
import { updatedriverstatus } from "@/services/user-service";
import { ColumnDef, useReactTable } from "@tanstack/react-table";
import {
  ArrowUpDown,
  EyeIcon,
  ShieldCheck,
  ShieldX,
  TrashIcon,
  Verified,
} from "lucide-react";
import Image from "next/image";

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.
// export type Payment = {
//   id: string;
//   amount: number;
//   status: "pending" | "processing" | "success" | "failed";
//   email: string;
// };

// "_id": "661db32f94e173a2c1644bc6",
//         "email": "newdriver2@yopmail.com",
//         "userType": "driver",
//         "image": "20240326_172208-1713310168318.jpg",0
//         "firstName": "new driver",
//         "lastName": "two",
//         "experience": "8",
//         "rating": 0,
//         "idCard": "1000000149-1713222840170.jpg"

export type Payment = {
  _id: string;
  image: string;
  firstName: string;
  lastName: string;
  email: string;
  experience: string;
  rating: number;
  idCard: string;
  isApproved: boolean;
  driverId: string;
};

// export type PaymentName = {
//   _id: string;
//   Image: string;
//   First Name: string;
//   last Name: string;
//   Email: string;
//   Experience: string;
//   Rating: number;
//   Id Card: string;
//   Is Approved: boolean;
//   Driver Id: string;
// };

const handleChange = async (driver_id: string, isApproved: boolean) => {
  const change_status = await updatedriverstatus(driver_id, isApproved);
  toast({
    title: change_status.message,
    //   description: (
    //     <pre className="mt-2 w-[340px] rounded-md bg-slate-950 p-4">
    //       <code className="text-white">{JSON.stringify(data, null, 2)}</code>
    //     </pre>
    //   ),
  });
};

export const columns: ColumnDef<Payment>[] = [
  {
    accessorKey: "Serial Number",
    header: "Serial Number",
    cell: ({ row }) => {
      // Get the index of the row and add 1 to start from 1 instead of 0
      const serialNumber = row.index + 1;
      return <span>{serialNumber}</span>;
    },
  },

  {
    accessorKey: "firstName",
    header: "First Name",
  },
  {
    accessorKey: "lastName",
    header: "Last Name",
  },
  {
    accessorKey: "email",
    header: ({ column }) => {
      return <h1>Email</h1>;
    },
    cell: ({ row }) => <div className="lowercase">{row.getValue("email")}</div>,
  },
  {
    accessorKey: "experience",
    header: "Experience",
  },
  {
    accessorKey: "isApproved",
    header: "Approved",
    cell: ({ row }) => {
      return (
        <div className="lowercase">
          {row.getValue("isApproved") ? (
            <ShieldCheck className="text-green-600" />
          ) : (
            <ShieldX className="text-red-600" />
          )}
        </div>
      );
    },
  },
  {
    accessorKey: "rating",
    header: "Rating",
  },

  {
    accessorKey: "idCard",
    header: "Actions",
    cell: ({ row }) => (
      <div className="flex">
        <Dialog>
          <DialogTrigger asChild>
            <Button
              disabled={!row.getValue("idCard")}
              size="icon"
              variant="ghost"
              className="rounded-full"
            >
              <EyeIcon size={20} className="text-blue-700" />
            </Button>
          </DialogTrigger>
          <DialogContent className="flex justify-center">
            <Carousel
              // opts={{
              //   align: "start",
              // }}
              className="w-full max-w-lg"
            >
              <CarouselContent>
                {[row.getValue("idCard")].map((e, index) => (
                  <CarouselItem
                    key={index}
                    // className="md:basis-1/2 lg:basis-1/3"
                  >
                    <div className="p-1">
                      <Card>
                        <CardContent className="flex aspect-square items-center justify-center">
                          <div>
                            <h1 className="flex justify-center font-semibold text-xl p-2">
                              ID Card Image
                            </h1>
                            {/* <span className="text-3xl font-semibold"> */}
                            {/* {index + 1} */}
                            <img src={URL + "/" + e} />
                          </div>
                          {/* </span> */}
                        </CardContent>
                      </Card>
                    </div>
                  </CarouselItem>
                ))}
              </CarouselContent>
              <CarouselPrevious />
              <CarouselNext />
            </Carousel>
            {/* {row.getValue("idCard") ? (
              <img src={URL + "/" + row.getValue("idCard")} alt="-" />
            ) : (
              <p>N/A</p>
            )}
            {row.original.image ? (
              <img src={URL + "/" + row.original.image} alt="-" />
            ) : (
              <p>N/A</p>
            )} */}
          </DialogContent>
        </Dialog>

        <div className="flex items-center space-x-2">
          <TooltipProvider>
            <Tooltip>
              <TooltipTrigger>
                <Switch
                  disabled={!row.original.idCard}
                  id="airplane-mode"
                  checked={row.original.isApproved}
                  onCheckedChange={() =>
                    handleChange(
                      row.original.driverId,
                      !row.original.isApproved
                    )
                  }
                />
              </TooltipTrigger>
              <TooltipContent>
                <p>
                  {row.original.isApproved
                    ? "Click To Unapprove Rider"
                    : "Click To Approve Rider"}
                </p>
              </TooltipContent>
            </Tooltip>
          </TooltipProvider>
        </div>
      </div>
    ),
  },
  // {
  //   accessorKey: "driverId",
  //   header: "driver Id",
  //   cell: ({ row }) => (
  //     <div className="flex">
  //       <Dialog>
  //         <DialogTrigger asChild>
  //           <Button size="icon" variant="ghost" className="rounded-full">
  //             <EyeIcon size={20} className="text-blue-700" />
  //           </Button>
  //         </DialogTrigger>
  //         <DialogContent className="flex justify-center">
  //           <Carousel
  //             // opts={{
  //             //   align: "start",
  //             // }}
  //             className="w-full max-w-lg"
  //           >
  //             <CarouselContent>
  //               {[row.original.image, row.getValue("idCard")].map(
  //                 (e, index) => (
  //                   <CarouselItem
  //                     key={index}
  //                     // className="md:basis-1/2 lg:basis-1/3"
  //                   >
  //                     <div className="p-1">
  //                       <Card>
  //                         <CardContent className="flex aspect-square items-center justify-center">
  //                           <div>
  //                             <h1 className="flex justify-center font-bold text-2xl p-2">
  //                               {index === 0 ? "Image" : "ID Card Image"}
  //                             </h1>
  //                             {/* <span className="text-3xl font-semibold"> */}
  //                             {/* {index + 1} */}
  //                             <img src={URL + "/" + e} />
  //                           </div>
  //                           {/* </span> */}
  //                         </CardContent>
  //                       </Card>
  //                     </div>
  //                   </CarouselItem>
  //                 )
  //               )}
  //             </CarouselContent>
  //             <CarouselPrevious />
  //             <CarouselNext />
  //           </Carousel>
  //           {/* {row.getValue("idCard") ? (
  //             <img src={URL + "/" + row.getValue("idCard")} alt="-" />
  //           ) : (
  //             <p>N/A</p>
  //           )}
  //           {row.original.image ? (
  //             <img src={URL + "/" + row.original.image} alt="-" />
  //           ) : (
  //             <p>N/A</p>
  //           )} */}
  //         </DialogContent>
  //       </Dialog>

  //       <Button
  //         size="icon"
  //         variant="ghost"
  //         className="rounded-full"
  //         // onClick={() => handleDelete(row.original._id)}
  //       >
  //         {row.getValue("driverId")}
  //       </Button>
  //     </div>
  //   ),
  // },
];

//  {
//    [row.original.image, row.getValue("idCard")].map((e, index) => (
//      <CarouselItem
//        key={index}
//        // className="md:basis-1/2 lg:basis-1/3"
//      >
//        <div className="p-1">
//          <Card>
//            <CardContent className="flex aspect-square items-center justify-center">
//              <div>
//                <h1 className="flex justify-center font-semibold text-xl p-2">
//                  {index === 0 ? "Image" : "ID Card Image"}
//                </h1>
//                {/* <span className="text-3xl font-semibold"> */}
//                {/* {index + 1} */}
//                <img src={URL + "/" + e} />
//              </div>
//              {/* </span> */}
//            </CardContent>
//          </Card>
//        </div>
//      </CarouselItem>
//    ));
//  }
