import Logout from "@/components/Logout";
import Providers from "@/components/Provider";
import Sidenav from "@/components/Sidenav";
import { Button } from "@/components/ui/button";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { ScrollArea } from "@/components/ui/scroll-area";
import { Toaster } from "@/components/ui/toaster";

export default function DashboardLayout({
  children, // will be a page or nested layout
}: {
  children: React.ReactNode;
}) {
  return (
    <section className="grid h-screen min-h-screen grid-cols-[280px_1fr]">
      {/* Include shared UI here e.g. a header or sidebar */}
      <Sidenav />
      <div className="flex flex-col overflow-hidden">
        <header className="flex h-14 lg:h-[60px] items-center gap-4 border-b bg-gray-100/40 px-6 dark:bg-gray-800/40">
          <div className="p-1 flex flex-1 items-center gap-4 md:ml-auto md:gap-2 lg:gap-4 justify-end">
            <DropdownMenu>
              <DropdownMenuTrigger asChild>
                <Button
                  size="icon"
                  variant="outline"
                  className="w-auto bg-gradient-to-b from-[#4e4bff] to-[#00006a] rounded-lg text-white  hover:text-slate-300"
                >
                  <h1 className="p-4">ADMIN</h1>
                </Button>
              </DropdownMenuTrigger>
              <DropdownMenuContent
                align="center"
                className="flex justify-center min-w-[2rem]"
              >
                <Logout />
              </DropdownMenuContent>
            </DropdownMenu>
          </div>
        </header>

        <ScrollArea>
          <main className="flex flex-1 flex-col gap-4 p-4 md:gap-8 md:p-6">
            <Providers>{children}</Providers>
            <Toaster />
          </main>
        </ScrollArea>
      </div>
    </section>
  );
}
