import { getAllDrivers, getRidesByType } from "@/services/user-service";
import { Payment, columns } from "./columns";
import { DataTable } from "./data-table";

export default async function page() {
  const data: Payment[] = await getRidesByType("completed");

  return (
    <>
      <h1 className="font-bold text-2xl capitalize m-4">Completed Bookings</h1>
      <div className="container mx-auto ">
        <DataTable columns={columns} data={data} />
      </div>
    </>
  );
}
