import { Button } from "@/components/ui/button";
import React from "react";
import SaveFare from "./SaveFare";

type Props = {
  adminCut: number;
};

const SliderDemo = (props: Props) => {
  return (
    <div className="flex flex-col items-center justify-center  dark:bg-gray-900">
      <div className="max-w-md w-full bg-white dark:bg-gray-800 rounded-lg shadow-lg p-8">
        <h1 className="text-3xl font-bold mb-4 text-gray-900 dark:text-gray-100">
          Change Admin Amount
        </h1>
        <div className="bg-gray-200 dark:bg-gray-700 rounded-lg p-6 mb-8">
          <p className="text-4xl font-bold text-[#1D3A7D]">{props.adminCut}%</p>
          <p className="text-gray-600 dark:text-gray-400">
            Percentage per Ride
          </p>
        </div>

        <SaveFare />
      </div>
    </div>
  );
};

export default SliderDemo;
