"use client";

import { zodResolver } from "@hookform/resolvers/zod";
import { useForm } from "react-hook-form";
import { z } from "zod";

import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormDescription,
  FormField,
  FormItem,
  FormLabel,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { toast } from "@/components/ui/use-toast";
import { useRouter } from "next/navigation";

import { changeCut } from "@/services/user-service";

const FormSchema = z.object({
  // email: z
  //   .string()
  //   .email({
  //     message: "Please enter a valid email address.",
  //   })
  //   .refine((value) => value !== undefined, {
  //     message: "Price is required.",
  //   }),
  // // password: z.string().min(1, {
  // //   message: "Please Enter Password",
  // // }),
  price: z.string().refine((value) => value !== undefined, {
    message: "Price is required.",
  }),
});

const SliderDemo = () => {
  const router = useRouter();
  const form = useForm<z.infer<typeof FormSchema>>({
    resolver: zodResolver(FormSchema),
    defaultValues: {
      price: "",
    },
  });

  async function onSubmit(data: z.infer<typeof FormSchema>) {
    const price = parseFloat(data.price);
    const reqserver: { status: string; message: string } = await changeCut(
      price
    );
    toast({
      title: reqserver.message,
      variant: "default",
    });
  }

  return (
    <>
      <Form {...form}>
        <form onSubmit={form.handleSubmit(onSubmit)} className="space-y-6">
          <h1 className="text-2xl font-bold"> New Percentage per Ride</h1>
          <FormField
            control={form.control}
            name="price"
            render={({ field }) => (
              <FormItem>
                <FormLabel>Set Price in Percentage %</FormLabel>
                <FormControl>
                  <Input
                    type="number"
                    step="0.01"
                    placeholder="Set Percentage"
                    {...field}
                  />
                </FormControl>
                <FormMessage />
              </FormItem>
            )}
          />
          <div className="flex justify-center">
            <Button type="submit" variant="appdefault" className="w-1/2">
              Save
            </Button>
          </div>
        </form>
      </Form>
      {/* <Button onClick={onSubmit2} className="w-1/2">
        onSubmit2
      </Button> */}
    </>
  );
};

export default SliderDemo;
